package gov.va.med.mhv.usermgmt.service;

import java.util.ArrayList;
import java.util.List;

import gov.va.med.mhv.usermgmt.enumeration.AuthenticationStatus;
import gov.va.med.mhv.usermgmt.transfer.InPersonAuthentication;
import gov.va.med.mhv.usermgmt.transfer.InPersonAuthenticationCriteria;
import gov.va.med.mhv.usermgmt.transfer.TransferObjectFactory;

public class TestIPASearch extends AbstractIPATest {
	protected List<InPersonAuthentication> ipaObjects;

	public void setUp() throws Exception {
		super.setUp();
		ipaObjects = new ArrayList<InPersonAuthentication>();
		ipaObjects.add(createInPersonAuthentication(patients.get(0), facilityInfos.get(0), AuthenticationStatus.getEnum(AuthenticationStatus.AUTHENTICATED)));
		ipaObjects.add(createInPersonAuthentication(patients.get(1), facilityInfos.get(1), AuthenticationStatus.getEnum(AuthenticationStatus.PREREQUISITESCOMPLETE)));
		ipaObjects.add(createInPersonAuthentication(patients.get(2), facilityInfos.get(0), AuthenticationStatus.getEnum(AuthenticationStatus.INPROCESS)));
	}

	public void tearDown() throws Exception {
		for(InPersonAuthentication ipa : ipaObjects){
			InPersonAuthenticationServiceResponse response = getUserEntityDelegate().delete(ipa.getInPersonAuthenticationPK());
			assertFalse(getErrors(response), hasErrors(response));
		}
		super.tearDown();
	}

	/** User should not be able to search with no criteria */
	public void testGenericSearch(){
		InPersonAuthenticationCriteria criteria = TransferObjectFactory.createInPersonAuthenticationCriteria();
		PatientInformationCollectionServiceResponse response = sDelegate.findPatients(criteria);
		assertTrue(response.getMessages().hasErrorMessages());
	}

	/*public void testSearchForAuthenticatedPatient(){
		InPersonAuthenticationCriteria criteria = TransferObjectFactory.createInPersonAuthenticationCriteria();
		criteria.setStatusAuthenticated(Boolean.TRUE);
		PatientInformationCollectionServiceResponse response = sDelegate.findPatients(criteria);
		assertFalse(response.getMessages().hasErrorMessages());
		assertEquals(1, response.getPatientInformations().size());
	}

	public void testSearchByFirstName(){
		InPersonAuthenticationCriteria criteria = TransferObjectFactory.createInPersonAuthenticationCriteria();
		criteria.setFirstName("Ge*");
		PatientInformationCollectionServiceResponse response = sDelegate.findPatients(criteria);
		assertFalse(response.getMessages().hasErrorMessages());
		assertEquals(2, response.getPatientInformations().size());

		criteria = TransferObjectFactory.createInPersonAuthenticationCriteria();
		criteria.setFirstName("Geor*g*");
		response = sDelegate.findPatients(criteria);
		assertFalse(response.getMessages().hasErrorMessages());
		assertEquals(1, response.getPatientInformations().size());

		criteria = TransferObjectFactory.createInPersonAuthenticationCriteria();
		criteria.setFirstName("GeOrGe");
		response = sDelegate.findPatients(criteria);
		assertFalse(response.getMessages().hasErrorMessages());
		assertEquals(1, response.getPatientInformations().size());

		criteria = TransferObjectFactory.createInPersonAuthenticationCriteria();
		criteria.setFirstName("Gerge");
		response = sDelegate.findPatients(criteria);
		assertFalse(response.getMessages().hasErrorMessages());
		assertEquals(0, response.getPatientInformations().size());
	}

	public void testSearchByLastName(){
		InPersonAuthenticationCriteria criteria = TransferObjectFactory.createInPersonAuthenticationCriteria();
		criteria.setLastName("Crab*");
		PatientInformationCollectionServiceResponse response = sDelegate.findPatients(criteria);
		assertFalse(response.getMessages().hasErrorMessages());
		assertEquals(1, response.getPatientInformations().size());

		criteria = TransferObjectFactory.createInPersonAuthenticationCriteria();
		criteria.setLastName("Crab*k");
		response = sDelegate.findPatients(criteria);
		assertFalse(response.getMessages().hasErrorMessages());
		assertEquals(1, response.getPatientInformations().size());

		criteria = TransferObjectFactory.createInPersonAuthenticationCriteria();
		criteria.setLastName("CRaBSH*");
		response = sDelegate.findPatients(criteria);
		assertFalse(response.getMessages().hasErrorMessages());
		assertEquals(1, response.getPatientInformations().size());

		criteria = TransferObjectFactory.createInPersonAuthenticationCriteria();
		criteria.setLastName("Crbshack");
		response = sDelegate.findPatients(criteria);
		assertFalse(response.getMessages().hasErrorMessages());
		assertEquals(0, response.getPatientInformations().size());
	}*/
}
